<?php
/* --------------------------------------------------------------
   FontAwesomeFallbackLoader.php 2020-02-20
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Layout\Smarty\Loaders;

use Smarty;

/**
 * Class FontAwesomeFallbackLoader
 *
 * @package Gambio\Admin\Layout\Smarty\Loaders
 */
class FontAwesomeFallbackLoader implements LoaderInterface
{
    /**
     * @inheritDoc
     */
    public function load(Smarty $smarty): void
    {
        $fontAwesomeFonts   = (array)glob(__DIR__ . '/../../../../admin/html/assets/fonts/fontawesome-free/*.ttf');
        $fontAwesomePresent = !empty($fontAwesomeFonts);
        
        $smarty->assign('fontawesome_fallback', !$fontAwesomePresent);
    }
}